<?php
# Based on the Example WikiMedia extension

# Enables syntax highlighting using the GeSHi (http://qbnz.com/highlighter/).
# Simply enclose you code in <yourlanguage></yourlanguage> tags, and voil, GeSHi will highlight it for you !


$wgExtensionFunctions[] = "wfGeshiExtension";

function wfGeshiExtension()
{
	include_once("extensions/geshi/geshi.php");

	// using a global looks like "porcasse-coding", but no, 
	// this is how the example WikiMedia extension is built :)
	global $wgParser;

	// available languages (i.e <actionscript/> tag, <ada/> tag, and so on will be available.
        $languagesArray = array("actionscript-french", "actionscript", "ada", "apache", "applescript",
	                        "asm", "asp", "bash", "c", "caddcl", "cadlisp", "cpp", "csharp", "css",
				"c_mac", "d", "delphi", "diff", "div", "dos", "eiffel", "freebasic", "gml",
				"html4strict", "ini", "inno", "java", "javascript", "lisp", "lua", "matlab",
				"mpasm", "nsis", "objc", "ocaml-brief", "ocaml", "oobas", "oracle8", "pascal",
				"perl", "php-brief", "php", "python", "qbasic", "ruby", "scheme", "sdlbasic",
				"smarty", "sql", "vb", "vbnet", "vhdl", "visualfoxpro", "xml");

	// for each available language, create an anonymous function that will handle it
        foreach ( $languagesArray as $language )
	{
		$code = <<<EOT
		// input is the test to highlight, that will be passed by WikiMedia
		\$geshi = new GeSHi(\$input, "$language", "extensions/geshi/geshi");
		\$geshi->set_encoding("utf-8");

		// here you can add code to configure the GeSHi, like activate line numbering,
		// use custom styles, etc.
	
		\$highlighted = \$geshi->parse_code();

		if(\$geshi->error)
			return \$geshi->error . "<br/>" . \$highlighted;
		else
			return \$highlighted;
EOT;
		
		$wgParser->setHook( $language, create_function('$input', $code) );
        }
}

?>

