<?php

class Cd extends Oeuvre implements LireEcrireDonnees
{
	private $label;
	private $auteursAdditionnels;

	function __construct($auteur, $titre, $annee, $label)
	{
		$this->label = $label;
		parent::__construct($auteur, $titre, $annee);
		$this->auteursAdditionnels = Array();
	}

	static function lireDonnees()
	{
		$retour = Array();
	       $dom = new domDocument();
	       $dom->load("cds.xml");

	       $cds = $dom->getElementsByTagName("cd");
	       foreach($cds as $cd)
	       {
		       $album = new Cd($cd->getAttribute("auteur"), $cd->getAttribute("titre"), $cd->getAttribute("annee"), $cd->getAttribute("label"));
		       $personnel = $cd->getElementsByTagName("personnel");		  
		       if($personnel)
		       {
			       foreach($personnel as $perso)
			       {
				       $perso = new Personnel($perso->getAttribute("nom"), $perso->getAttribute("activite"));
				       $album->ajouterAuteurAdditionnel($perso);
			       }
		       }
		       $retour[] = $album;
	       }
	       return $retour;
       }

	function ecrireDonnees()
	{
	  $dom = new domDocument();
	  if(file_exists("cds.xml"))
		  $dom->load("cds.xml");
          else
	  	$dom->loadxml("<cds/>");
		
	  $cd = $dom->createElement("cd");
	  $cd->setAttribute("auteur", $this->auteur);
	  $cd->setAttribute("titre", $this->titre);
	  $cd->setAttribute("annee", $this->annee);
	  $cd->setAttribute("label", $this->label);
	  
	  foreach($this->auteursAdditionnels as $aa)
	  {
		  $aaElement = $dom->createElement("personnel");
		  $aaElement->setAttribute("nom", $aa->getNom());
		  $aaElement->setAttribute("activite", $aa->getActivite());
		  $cd->appendChild($aaElement);
	  }
	  $dom->documentElement->appendChild($cd);
	 $dom->save("cds.xml");
	}

	function __toString()
	{
		$ret = $this->titre . " par " . $this->auteur
	               . " (" . $this->annee . ", dit par " . $this->label .")<br/>";
		foreach($this->auteursAdditionnels as $aa)
			$ret .= $aa->__toString() . "<br/>";
		return $ret;
	}
		
	function ajouterAuteurAdditionnel(Personnel $valeur)
        {
	       $this->auteursAdditionnels[] = $valeur;
       }	
}
?>
